/***************************************************************/
//
//
//		DirectX	[ debugmanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 1/7
/*---------------------------------------------------------------
Update : 2017/1/7
			debugmanager.h̍쐬
			CDebugManager̍쐬
			CLASS : CDebugManager
				CDebugManager::Init̒ǉ
				CDebugManager::Uninit̒ǉ
				CDebugManager::Update̒ǉ
				CDebugManager::Draw̒ǉ

Update : 2016/1/7



/*-------------------------------------------------------------*/
#ifndef _DEBUGMANAGER_H_

#define _DEBUGMANAGER_H_


/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include <vector>
#include <map>

typedef unsigned int MY_NUMBER;

using namespace std;      								// WCuOԎw

#define PROCESS_COUNT (256)								// ۑĂ

// fobONX
class CConsole;											// R\[pfobONX
class CDebugLog;										// Ot@CpfobONX
class CDebugFont;										// WindowpfobONX

/*---------------------------------------------------------------
	CLASS
-----------------------------------------------------------------*/

// fobO}l[W[
class CDebugManager
{
public:

	CDebugManager();									// }l[W[̃RXgN^
	~CDebugManager();									// }l[W[̃fXgN^
	
	void Init( void );									// }l[W[̏
	void Uninit( void );								// }l[W[̏I
	void Update( void );								// }l[W[̍XV
	void Draw( void );									// }l[W[̕`揈
	
	void StartMeasureProcess( void );					// ̌vJn
	void EndMeasureProcess( void );						// ̌vI
	void StartMeasureProcess( const int index );		// ̌vJn(w)
	void EndMeasureProcess( const int index );			// ̌vJn(w)
	void UpdateGraph( void );							// f[^̍XVȂ
	void DrawGraph( void );								// ԃOt̕`
	
	CDebugLog* GetDebugLog( void );						// fobOÕ|C^擾
	CDebugFont* GetDebugFont( void );					// fobOtHg̃|C^擾
	
	// X^eBbNo֐
	static CDebugManager* Create( void );				// }l[W[̍쐬
	static CDebugManager* IndexAccess(const int number);// CfbNXԍ̃|C^̎擾
	
#if _UNICODE
	// fobOiUNICODEpj
	//static HRESULT IndexAccess( const wstring name );	// CfbNXԍ̃|C^̎擾(UNICODE)
#else
	// fobOiANCIpj
	//static HRESULT IndexAccess( const string name );	// CfbNXԍ̃|C^̎擾(ANSI)
#endif
	
	static void UpdateAll( void );						// }l[W[XV
	static void DrawAll( void );						// }i[W[`揈
	static void ReleaseAll( void );						// S}l[W[̔j	
	
private:
	
	void Release( void );								// }l[W[̉
	
	MY_NUMBER   myNumber;								// }l[Wԍ
	
	CConsole*   pDebugConsole;							// R\[pfobONX̃|C^
	CDebugLog*  pDebugLog;								// Ot@CpfobONX̃|C^
	CDebugFont* pDebugWindow;							// WindowpfobONX̃|C^
	
	D3DXVECTOR3 pos;									// eNX`̈ʒuW
	LPDIRECT3DVERTEXBUFFER9 pVtxBuf;					// _obt@C^[tF[Xւ̃|C^
	LPDIRECT3DTEXTURE9  pTexture;						// eNX`|C^̃AhX
	LPDIRECT3DTEXTURE9  pBackGround;					// eNX`|C^̃AhX
	IDirect3DSurface9*  pSurface;						// eNX`T[tFX
	IDirect3DSurface9*  pBackbuf;						// obNobt@|C^i[
	
	LPD3DXLINE  pLine;									// Ot`pfoCX̃|C^
	D3DXVECTOR2 point[PROCESS_COUNT];					// xf[^i[p
	
	std::vector<LARGE_INTEGER> nFreq;					// g
	std::vector<LARGE_INTEGER> nBefore;					// Jn
	std::vector<LARGE_INTEGER> nAfter;					// I
	
	LARGE_INTEGER freq;
	LARGE_INTEGER before;
	LARGE_INTEGER after;
	
	std::vector<DWORD> dwTime;							// Ԋi[
	
	vector< map<string, int> > 	name;					// v̐(AzzvectorIz)
	int measureNumber;									// v̐
	
	// X^eBbNoϐ
	static std::vector<CDebugManager*> pManager;		// }l[W[AhX
	static int counter;									// }l[W[̌
	static LPDIRECT3DDEVICE9 pDevice;					// DirectXfoCX̃AhX
	
};



#endif	//	_DEBUGMANAGER_H_


